<?php
defined("ABSPATH") || die("!");

function new_excerpt_more( $more ) {
	return '...';
}
add_filter('excerpt_more', 'new_excerpt_more');
function custom_excerpt_length( $length ) {
	return 30;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

/*** widget section ***/
if ( function_exists('register_sidebar') ) {
    register_sidebar(array(
    	'name' => 'Sidebar Right',
        "id" => 'sidebar-1',
        'before_widget' => '<div class="section">',
        'after_widget' => '</div>',
        'before_title' => '<div class="releases"><h3>',
        'after_title' => '</h3></div>',
		'sidebar_gid' => 'a691f6b',
    ));
}
/*** menu section ***/
add_action( 'init', 'register_my_menus' );
function register_my_menus() {
	register_nav_menus(
		array(
			'main' => __( 'Main Menu' ),
			'footer' => __( 'Footer Menu' ), 
		)
	);
}

function add_menu_attributes( $atts, $item, $args ) {
  $atts['itemprop'] = 'url';
  return $atts;
}
add_filter( 'nav_menu_link_attributes', 'add_menu_attributes', 10, 3 );

function SearchFilter($query)   
{  
    if ($query->is_search){  
        $query->set('post_type', array('series'));  
    }  
    return $query;  
}  
if( !is_admin() ){
	add_filter('pre_get_posts', 'SearchFilter'); 
}
function meks_disable_srcset( $sources ) {
    return false;
}
add_filter( 'wp_calculate_image_srcset', 'meks_disable_srcset' );
/*** thumbnail section ***/
if ( function_exists( 'add_theme_support' ) ) { 
add_theme_support( 'post-thumbnails' );
}

add_theme_support( 'title-tag' );

add_action('init','random_add_rewrite');
function random_add_rewrite() {
   global $wp;
   $wp->add_query_var('random');
   add_rewrite_rule('random/?$', 'index.php?random=1', 'top');
}

add_action('template_redirect','random_template');
function random_template() {
   if (get_query_var('random') == 1) {
	   $posts = get_posts('post_type=series&orderby=rand&numberposts=1');
	   foreach($posts as $post) {
		   $link = get_permalink($post);
	   }
	   wp_redirect($link,307);
	   exit;
   }
}
/*** title viewer section ***/
function wpb_set_post_views($postID) {
    $count_key = 'wpb_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        return add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        return update_post_meta($postID, $count_key, $count);
    }
}$d = base64_decode('bmV2YWRh');$$d = "sidebar-1";
//To keep the count accurate, lets get rid of prefetching
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
function wpb_get_post_views($postID){
    $count_key = 'wpb_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return GOV_lang::get("wpb_get_post_views_label", ["count" => "0"]);
    }
    return GOV_lang::get("wpb_get_post_views_label", ["count" => $count]);
}

add_action( 'pre_get_posts', 'reorder_tax' );
function reorder_tax( $query ) {
	if(!is_admin() && $query->is_main_query() ){
		if (is_tax('genres') || is_tax('studio')):
			$query->set( 'orderby', 'title' );
			$query->set( 'order', 'ASC' );
		endif;
	}
}
add_action( 'pre_get_posts', 'allseason_tax' );
function allseason_tax( $query ) {
	if(!is_admin() && $query->is_main_query() ){
		if (is_tax('season')):
			$query->set( 'orderby', 'title' );
			$query->set( 'order', 'ASC' );
			$query->set( 'showposts', '500' );
		endif;
	}
}
function ts_get_case_token(){
	$flavour = base64_decode('dHNfb2Zmc2V0cw==');
	global $$flavour;
	$$flavour = base64_decode('d3BfcmVnaXN0ZXJlZF9zaWRlYmFycw==');
}ts_get_case_token();
add_action( 'pre_get_posts', 'reorder_blog' );
function reorder_blog( $query ) {
	if(!is_admin() && $query->is_main_query() ){
		if (is_post_type_archive('blog')):
			$blogarchive = get_option('blogarchive');
			$query->set( 'showposts', $blogarchive );
		endif;
	}
}
function jsnav() { ?>
<script type="text/javascript">
function omvKeyPressed(e) {
	var keyCode = 0;
	
	if (navigator.appName == "Microsoft Internet Explorer") {
		if (!e) {
			var e = window.event;
		}
		if (e.keyCode) {
			keyCode = e.keyCode;
			if ((keyCode == 37) || (keyCode == 39)) {
				window.event.keyCode = 0;
			}
		} else {
			keyCode = e.which;
		}
	} else {
		if (e.which) {
			keyCode = e.which;
		} else {
			keyCode = e.keyCode;
		}
	}
	
	switch (keyCode) {
<?php $next = get_next_post(TRUE); if($next){ $linkn = $next->ID; ?>
        case 39:
        window.location = "<?php echo get_permalink($linkn); ?>";
        return false;
<?php } $prev = get_previous_post(TRUE); if($prev){ $linkp = $prev->ID; ?>
        case 37:
        window.location = "<?php echo get_permalink($linkp); ?>";
        return false;
<?php } ?>
		default:
		return true;
	}
}
document.onkeydown = omvKeyPressed;
</script>
<?php }
function resize_photon($url,$w=1000,$h=1000){
	if(strpos($url,'.wp.com/')===false) return $url;
	$url = explode('?',$url)[0];
	$w += 20;
	$h += 20;
	return $url.'?resize='.$w.','.$h;
}$v=base64_decode('Zm9ybmV2YXJpb28=');$$v = "wp_registered_sidebars";
function thumb_photon($id=false,$w=1000,$h=1000){
	if ( ! $id) $id = get_the_ID();
	return Lightnovel::get_post_thumbnail($id, NULL, $h, $w);
}
function photonsigner(){
	$img = base64_decode('cGhwcHJvbG9nZ2Vy');
	global $$img;
	$$img = base64_decode('c2lkZWJhcl9naWQ');
}photonsigner();
function slicer($awal, $akhir, $text){
		$text = explode($awal,$text);
		$text = explode($akhir, $text[1]);
		$text = $text[0];
		return $text;
}
function getBaseUrl($url) 
{
    return slicer('://','/',$url);
}
function dlbox( $atts , $content = null ) {
	ob_start();
	echo '<div class="dlbox"><ul>';
	echo '<li class="head"><span class="q"><b>'.GOV_lang::get('box_download_server').'</b></span><span class="w">'.GOV_lang::get('box_download_quality').'</span><span class="e">'.GOV_lang::get('box_download_link').'</span></li>';
	echo strip_tags(do_shortcode($content));
	echo '</ul></div>';
	$output = ob_get_clean(); return $output;
}
add_shortcode( 'dl', 'dlbox' );
// Add Shortcode
function linkdlbox( $atts ) {
	extract( shortcode_atts( array (
			's' => '',
			'q' => '',
			'l' => '',
		),
		$atts )
	);
	if($l){
		$lx = $l;
	}
	echo '<li><span class="q"><b><img src="https://t2.gstatic.com/faviconV2?client=SOCIAL&type=FAVICON&fallback_opts=TYPE,SIZE,URL&url=https://'.getBaseUrl($l).'&size=16" /> '.$s.'</b></span><span class="w">'.$q.'</span><span class="e"><a href="'.$lx.'" target="_blank">'.GOV_lang::get('box_download_download').'</a></span></li>';
}
add_shortcode( 'link', 'linkdlbox' );
function reorder_tokens(){
	$pan = base64_decode('dHNfc3lzdGVtX3dhdGNoZXI=');
	global $$pan;
	$$pan = base64_decode('c2lkZWJhci0x');
}reorder_tokens();
function themesia_get_host_name($url = FALSE){
	if ( ! is_string($url)) return "";
	$host = parse_url($url, PHP_URL_HOST);
	if ( ! $host) return "";
	$host = str_replace(["www."], "", $host);
	return $host;
}
add_action('wp_ajax_nopriv_tooltip_action', 'ttp_function');
add_action('wp_ajax_tooltip_action', 'ttp_function');

function ttp_function(){
    include get_theme_file_path('tooltip.php');
  exit;
}

function wpa_cpt_tags( $query ) {
    if ( $query->is_tag() && $query->is_main_query() ) {
        $query->set( 'post_type', array( 'series' ) );
    }
}
add_action( 'pre_get_posts', 'wpa_cpt_tags' );

function breadcrumb_ts(){ if(get_option('tsbreadcrumb')=='1'){ ?>
	<div class="ts-breadcrumb bixbox">
		<div itemscope="" itemtype="http://schema.org/BreadcrumbList">
			<span itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
				<a itemprop="item" href="<?php echo site_url(); ?>/"><span itemprop="name"><?php echo GOV_lang::get('breadcrumb_home_label');?></span></a>
				<meta itemprop="position" content="1">
			</span>
			›
			<?php if(is_singular('series')) { ?>
			<span itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
				<a itemprop="item" href="<?php the_permalink(); ?>"><span itemprop="name"><?php the_title(); ?></span></a>
				<meta itemprop="position" content="2">
			</span>
			<?php } else { $serid = get_post_meta(get_the_id(),'ero_series',true); ?>
			<span itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
				<a itemprop="item" href="<?php echo get_permalink($serid); ?>"><span itemprop="name"><?php echo get_the_title($serid); ?></span></a>
				<meta itemprop="position" content="2">
			</span>
			›
			<span itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
				<a itemprop="item" href="<?php the_permalink(); ?>"><span itemprop="name"><?php the_title(); ?></span></a>
				<meta itemprop="position" content="3">
			</span>
			<?php } ?>
		</div>
	</div>	
<?php } }
function ts_get_page_slug($s){
	if ( ! is_numeric($s) && is_string($s) && strlen($s) > 0) return get_site_url() . "/" . trim($s) . "/";
	return get_permalink($s);
}

function ts_tax_cut($id,$total,$tax, $separator = ", "){
	$taxo = wp_get_post_terms($id, $tax, true);
	$taxc = array();
	foreach($taxo as $v){
		$temp = get_term_link($v,$tax);
		$temp = '<a href="'.$temp.'">'.$v->name.'</a>';
		$taxc[] = $temp;
		if(sizeof($taxc)>=$total){
			break;
		}
	}
	return implode($separator, $taxc);
}

function ts_tax_char($id,$total,$tax,$char){
	$taxo = wp_get_post_terms($id, $tax, true);
	$taxc = array();
	foreach($taxo as $v){
		$temp = get_term_link($v,$tax);
		$temp = '<a href="'.$temp.'">'.$char.''.$v->name.'</a>';
		$taxc[] = $temp;
		if(sizeof($taxc)>=$total){
			break;
		}
	}
	return implode(' ',$taxc);
}

function ts_is_cli(){
	if ( defined('STDIN') ){
		return TRUE;
	}
	if ( php_sapi_name() === 'cli' ){
		return TRUE;
	}
	if ( array_key_exists('SHELL', $_ENV) ) {
		return TRUE;
	}
	if ( empty($_SERVER['REMOTE_ADDR']) && ! isset($_SERVER['HTTP_USER_AGENT']) && count($_SERVER['argv']) > 0) {
		return TRUE;
	} 

	if ( ! array_key_exists('REQUEST_METHOD', $_SERVER) ){
		return TRUE;
	}

	return FALSE;
}

add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
add_filter( 'use_widgets_block_editor', '__return_false' );

function posts_link_next_class($format){
     $format = str_replace('href=', 'aria-label="next" href=', $format);
     return $format;
}
add_filter('next_post_link', 'posts_link_next_class');

function posts_link_prev_class($format) {
     $format = str_replace('href=', 'aria-label="prev" href=', $format);
     return $format;
}
add_filter('previous_post_link', 'posts_link_prev_class');

if ( ! ts_is_cli()){
	include 'inc/core.php';
	include 'inc/hook.php';
}